﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;
using System.IO.Ports;


namespace mavoSOFT_virtualMASTER
{
    public partial class Form1 : Form
    {
        public SerialPort comPort1 = new SerialPort("COM1", 9600, Parity.None, 8, StopBits.One);

        private System.Timers.Timer NoDataAvailable = new System.Timers.Timer(100);
        enum REPLY : int { NO_REPLY, YES_REPLY, TIMEOUT_REPLY };
        private REPLY Reply_Status;

        private bool Device_connected = false;

        private double MeasuredValue1 = 0;
        private double MeasuredValue2 = 0;
        private UInt32 ChartCounter = 0;

        private string Programtitle = "mavoSOFT virtualMASTER demo v1.0";



        public Form1()
        {
            InitializeComponent();
            this.Text = Programtitle;

            Graph.Series["CH1"].Points.AddXY(0, 0);
            Graph.Series["CH2"].Points.AddXY(0, 0);
        }
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            disconnect_Probe();
        }



        // Port Handling, just Flags...
        private void comPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        #region
        {
            Reply_Status = REPLY.YES_REPLY;
        }
        #endregion
        private void comPort_OnTimeOut(object sender, EventArgs e)
        #region
        {
            Reply_Status = REPLY.TIMEOUT_REPLY;
        }
        #endregion



        // Function for sending a command, including checking
        public string SendCommand(string txStr)
        #region
        {
            int watchdog = 0;

            string rxStr = "";
            Reply_Status = REPLY.NO_REPLY;

            try
            {
                rxStr = comPort1.ReadExisting();     // Buffer vor dem Senden leeren, falls noch Reste drin sind
                comPort1.WriteLine(txStr);
            }
            catch (Exception) { }

            System.Threading.Thread.Sleep(50);

            // Wait Acknowledge
            watchdog = 0;
            while (Reply_Status == REPLY.NO_REPLY)
            {
                if (watchdog++ > 100)
                {
                    return "ERROR1";
                }
                System.Threading.Thread.Sleep(10);
                NoDataAvailable.Enabled = true;
            }

            NoDataAvailable.Enabled = false;

            if (Reply_Status == REPLY.TIMEOUT_REPLY)
            {
                rxStr = "ERROR";
            }
            else if (Reply_Status == REPLY.YES_REPLY)
            {
                System.Threading.Thread.Sleep(50);

                try
                {
                    rxStr = comPort1.ReadExisting();
                }
                catch (Exception) { }

                watchdog = 0;
                while (!rxStr.Contains('\n'))
                {
                    if (watchdog++ > 100)
                    {
                        return "ERROR2";
                    }

                    System.Threading.Thread.Sleep(10);
                    try
                    {
                        rxStr += comPort1.ReadExisting();
                    }
                    catch (Exception) { }
                }
            }
            else
            {
                rxStr = "ERROR";
            }
            return rxStr;
        }
        #endregion




        private bool connect_to_Probe()
        #region
        {
            String ReceivedData;
            bool Probegefunden = false;

            string[] ArrayComPortsNames = null;
            int index = -1;
            string ComPortName = null;
            ArrayComPortsNames = SerialPort.GetPortNames();


            this.comPort1.DataReceived += new SerialDataReceivedEventHandler(comPort_DataReceived);
            this.NoDataAvailable.Elapsed += new System.Timers.ElapsedEventHandler(comPort_OnTimeOut);
            this.NoDataAvailable.Interval = 1000;

            // No Ports found -> return
            if (ArrayComPortsNames.GetLength(0) == 0)
                return false;

            // go through all available Port-Numbers
            do
            {
                index += 1;
                comPort1.PortName = ArrayComPortsNames[index];

                try
                {
                    //first check if the port is already open
                    //if its open then close it
                    if (comPort1.IsOpen == true) 
                        comPort1.Close();
                    
                    // Open the Port
                    comPort1.Open();

                    // Ask the Device to indentify itself
                    ReceivedData = SendCommand("*IDN?");
                    try
                    {
                        // If the Answer includes GOSSEN and PROBE then we found the device
                        if ((ReceivedData.IndexOf("GOSSEN", 0) != -1) && (ReceivedData.IndexOf("PROBE", 0) != -1))
                        {
                            Probegefunden = true;
                            ComPortName = comPort1.PortName;
                        }
                    }
                    catch (Exception) { }
                }
                catch (Exception) { }

                comPort1.Close();

            }
            while (!((ArrayComPortsNames[index] == ComPortName) || (index == ArrayComPortsNames.GetUpperBound(0))));

            if(Probegefunden)
            {
                comPort1.Open();
                return true;
            }

            return false;
        }
        #endregion
        private void disconnect_Probe()
        #region
        {
            if (comPort1.IsOpen)
            {
                comPort1.Close();
                Device_connected = false;
            }
        }
        #endregion



        // Connect-Disconnect-Button
        private void btnConnect_Click(object sender, EventArgs e)
        #region
        {
            if (!Device_connected)                        // keine Probe da, dann suchen und Timer starten
            {
                Device_connected = connect_to_Probe();

                if (Device_connected)
                    MeasurementTimer.Enabled = true;

                btnConnect.Text = "Disconnect";
            }
            else                                        // Probe schon da, dann weg und Timer ausschalten
            {
                MeasurementTimer.Enabled = false;

                disconnect_Probe();

                lbl_Wert1.Text = "";
                lbl_Wert2.Text = "";

                btnConnect.Text = "Connect to Device";
            }
        }
        #endregion
        // Clear the Graph
        private void btn_GraphClear_Click(object sender, EventArgs e)
        #region
        {
            Graph.Series["CH1"].Points.Clear();
            Graph.Series["CH2"].Points.Clear();
            ChartCounter = 0;
        }
        #endregion





        // Timer for retrieveing Measured Values
        private void MeasuredValueTimer_Tick(object sender, EventArgs e)
        #region
        {
            string rxStr;
            string[] rxStrParts;

            rxStr = SendCommand("?");

            rxStrParts = rxStr.Replace('\n', ',').Replace("\r", "").Replace(",", "").Split(' ');


            MeasuredValue1 = 0;
            try
            {
                lbl_Wert1.Text = rxStrParts[0] + " " + rxStrParts[1];
                MeasuredValue1 = Convert.ToDouble(rxStrParts[0]);
            }
            catch (Exception) { }


            MeasuredValue2 = 0;
            try
            {
                lbl_Wert2.Text = rxStrParts[3] + " " + rxStrParts[4];
                MeasuredValue2 = Convert.ToDouble(rxStrParts[3]);
            }
            catch (Exception) { }
            


            // Paint the Graph
            Graph.Series["CH1"].Points.AddXY(ChartCounter, MeasuredValue1);
            Graph.Series["CH2"].Points.AddXY(ChartCounter, MeasuredValue2);
            ChartCounter += 1;
            Graph.Refresh();
        }



        #endregion





        private void MavoMasterLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("https://gossen-photo.de/mavomaster/");
        }

        private void HomepageLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("https://www.gossen-photo.de");
        }
    }
}
